// PanelScripts.cpp : implementation file
//

#include "stdafx.h"
#include "DcDcUsb.h"
#include "DcDcUsbDlg.h"
#include "PanelScripts.h"
#include "SleepDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CPanelScripts dialog

IMPLEMENT_DYNAMIC(CPanelScripts, CDialog)

CPanelScripts::CPanelScripts(CDcDcUsbDlg* mainDlg, CWnd* pParent /*=NULL*/)
	: CDialog(CPanelScripts::IDD, pParent)
{
	m_pMainDlg = mainDlg;
	for (int i=0;i<SCRIPTS_PACKS;i++) m_bPackagesArrived[i] = false;
	m_nLastSelectedAddress = 0;
}

CPanelScripts::~CPanelScripts()
{
}

void CPanelScripts::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON_SCRIPT_SEND, m_bSend);
	DDX_Control(pDX, IDC_EDIT_VOLTAGE, m_eVoltage);
	DDX_Control(pDX, IDC_COMBO_SCRIPTNO, m_cbScriptNo);
	DDX_Control(pDX, IDC_COMBO_VOUT_T1, m_cbVoutT1);
	DDX_Control(pDX, IDC_COMBO_VOUT_T2, m_cbVoutT2);
	DDX_Control(pDX, IDC_COMBO_VAUX_T1, m_cbVAuxT1);
	DDX_Control(pDX, IDC_COMBO_VAUX_T2, m_cbVAuxT2);
	DDX_Control(pDX, IDC_COMBO_VPSW_T1, m_cbVPswT1);
	DDX_Control(pDX, IDC_COMBO_VPSW_T2, m_cbVPswT2);
	DDX_Control(pDX, IDC_EDIT_VOUT_TIME1, m_eVOutT1);
	DDX_Control(pDX, IDC_EDIT_VOUT_TIME2, m_eVOutT2);
	DDX_Control(pDX, IDC_EDIT_VAUX_TIME1, m_eVAuxT1);
	DDX_Control(pDX, IDC_EDIT_VAUX_TIME2, m_eVAuxT2);
	DDX_Control(pDX, IDC_EDIT_VPSW_TIME1, m_eVPwsT1);
	DDX_Control(pDX, IDC_EDIT_VPSW_TIME2, m_eVPwsT2);
	DDX_Control(pDX, IDC_EDIT_VPSW_TIME3, m_eGlobalWTime);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_NEXT, m_bScriptNext);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_REPEAT, m_bScriptRepeat);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_DISABLE, m_cbDisable);
}


BEGIN_MESSAGE_MAP(CPanelScripts, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SCRIPT_START, &CPanelScripts::OnBnClickedButtonScriptStart)
	ON_BN_CLICKED(IDC_BUTTON_SCRIPT_STOP, &CPanelScripts::OnBnClickedButtonScriptStop)
	ON_CBN_SELCHANGE(IDC_COMBO_SCRIPTNO, &CPanelScripts::OnCbnSelchangeComboScriptno)
	ON_BN_CLICKED(IDC_BUTTON_SCRIPT_SEND, &CPanelScripts::OnBnClickedButtonScriptSend)
	ON_BN_CLICKED(IDC_BUTTON_SCRIPT_SLEEP, &CPanelScripts::OnBnClickedButtonScriptSleep)
	ON_BN_CLICKED(IDC_CHECK_SCRIPT_DISABLE, &CPanelScripts::OnBnClickedCheckScriptDisable)
END_MESSAGE_MAP()


// CPanelScripts message handlers

void CPanelScripts::OnBnClickedButtonScriptStart()
{
	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SCRIPT_START, 0, 0);
}

void CPanelScripts::OnBnClickedButtonScriptStop()
{
	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SCRIPT_STOP, 0, 0);
}

BOOL CPanelScripts::OnInitDialog()
{
	CDialog::OnInitDialog();

	for (int i=0;i<60;i++)
	{
		CString s;s.Format("%d",i+1);
		m_cbScriptNo.AddString(s);
	}

	m_cbScriptNo.SetCurSel(0);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

bool CPanelScripts::LoadValues(bool reset_all, bool visual)
{
	int bank = m_cbScriptNo.GetCurSel();
	int addr = SCRIPT_START_ADDR + 64 * (bank / 4);
	if ((!reset_all) && (addr == m_nLastSelectedAddress)) return false;
	
	m_nLastSelectedAddress = addr;
	for (int i=0;i<SCRIPTS_PACKS;i++) m_bPackagesArrived[i] = false;
	memset(m_chPackages,0,SCRIPTS_PACKS*16);

	m_cbScriptNo.EnableWindow(FALSE);
	m_bSend.EnableWindow(FALSE);
	m_cbDisable.EnableWindow(FALSE);

	m_eVoltage.EnableWindow(FALSE);
	m_cbVoutT1.EnableWindow(FALSE);
	m_cbVoutT2.EnableWindow(FALSE);
	m_cbVAuxT1.EnableWindow(FALSE);
	m_cbVAuxT2.EnableWindow(FALSE);
	m_cbVPswT1.EnableWindow(FALSE);
	m_cbVPswT2.EnableWindow(FALSE);
	m_eVOutT1.EnableWindow(FALSE);
	m_eVOutT2.EnableWindow(FALSE);
	m_eVAuxT1.EnableWindow(FALSE);
	m_eVAuxT2.EnableWindow(FALSE);
	m_eVPwsT1.EnableWindow(FALSE);
	m_eVPwsT2.EnableWindow(FALSE);
	m_eGlobalWTime.EnableWindow(FALSE);
	m_bScriptNext.EnableWindow(FALSE);
	m_bScriptRepeat.EnableWindow(FALSE);

	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10);

	addr += 16;
	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10);

	addr += 16;
	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10);

	addr += 16;
	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10);

	return true;
}

void CPanelScripts::AddPackage(unsigned long address, unsigned long length, HArray* parray)
{
	if (address == m_nLastSelectedAddress)
	{
		m_bPackagesArrived[0]=true;
		memcpy(m_chPackages, parray->getBuf()+5, 16);
	}
	else if (address == (m_nLastSelectedAddress+16))
	{
		m_bPackagesArrived[1]=true;
		memcpy(m_chPackages+16, parray->getBuf()+5, 16);
	}
	else if (address == (m_nLastSelectedAddress+32))
	{
		m_bPackagesArrived[2]=true;
		memcpy(m_chPackages+2*16, parray->getBuf()+5, 16);
	}
	else if (address == (m_nLastSelectedAddress+48))
	{
		m_bPackagesArrived[3]=true;
		memcpy(m_chPackages+3*16, parray->getBuf()+5, 16);

		if (m_bPackagesArrived[0] && m_bPackagesArrived[1] && m_bPackagesArrived[2] && m_bPackagesArrived[3])
		{
//			m_cbScriptNo.SetCurSel(0);
			m_cbScriptNo.EnableWindow(TRUE);
			m_bSend.EnableWindow(TRUE);
			m_cbDisable.EnableWindow(TRUE);

			m_eVoltage.EnableWindow(TRUE);
			m_cbVoutT1.EnableWindow(TRUE);
			m_cbVoutT2.EnableWindow(TRUE);
			m_cbVAuxT1.EnableWindow(TRUE);
			m_cbVAuxT2.EnableWindow(TRUE);
			m_cbVPswT1.EnableWindow(TRUE);
			m_cbVPswT2.EnableWindow(TRUE);
			m_eVOutT1.EnableWindow(TRUE);
			m_eVOutT2.EnableWindow(TRUE);
			m_eVAuxT1.EnableWindow(TRUE);
			m_eVAuxT2.EnableWindow(TRUE);
			m_eVPwsT1.EnableWindow(TRUE);
			m_eVPwsT2.EnableWindow(TRUE);
			m_eGlobalWTime.EnableWindow(TRUE);
			m_bScriptNext.EnableWindow(TRUE);
			m_bScriptRepeat.EnableWindow(TRUE);

			Display4Steps();
		}
	}
}

void CPanelScripts::OnCbnSelchangeComboScriptno()
{
	if (!LoadValues(false, true))
		Display4Steps();//if no request was sent = the selected 64 byte bank remained the same so a simple display is need only
}

void CPanelScripts::Display4Steps()
{
	/*
RX[24]:A2 80 3F 00 10  FD 34 00 14 00 1E 00 05 00 0A 00 32 FF FF 00 3C  00 00 01 
RX[24]:A2 90 3F 00 10  FF D2 00 0A 00 0A 00 3C 00 0A 00 32 FF FF 00 3C  00 00 01 
RX[24]:A2 A0 3F 00 10  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  00 00 01 
RX[24]:A2 B0 3F 00 10  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  00 00 01 
	*/
	int scriptno = (m_cbScriptNo.GetCurSel() % 4);

	unsigned char* buff = m_chPackages + scriptno*16;

	CString str;
	
	str = CPanelSettings::ConvertOneValue(buff, 1, 1, 7, 0);
	m_eVoltage.SetWindowText(str);

	if (buff[0] & 0x80) m_cbVoutT1.SetCurSel(1); else m_cbVoutT1.SetCurSel(0);
	if (buff[0] & 0x40) m_cbVoutT2.SetCurSel(1); else m_cbVoutT2.SetCurSel(0);
	m_eVOutT1.SetWindowText(CPanelSettings::ConvertOneValue(buff, 2, 2, 3, 1));//bytes2string(buff[2],buff[3]));
	m_eVOutT2.SetWindowText(CPanelSettings::ConvertOneValue(buff, 2, 4, 3, 1));//bytes2string(buff[4],buff[5]));
	if (buff[0] & 0x20) m_cbVAuxT1.SetCurSel(1); else m_cbVAuxT1.SetCurSel(0);
	if (buff[0] & 0x10) m_cbVAuxT2.SetCurSel(1); else m_cbVAuxT2.SetCurSel(0);
	m_eVAuxT1.SetWindowText(CPanelSettings::ConvertOneValue(buff, 2, 6, 3, 1));//bytes2string(buff[6],buff[7]));
	m_eVAuxT2.SetWindowText(CPanelSettings::ConvertOneValue(buff, 2, 8, 3, 1));//bytes2string(buff[8],buff[9]));
	if (buff[0] & 0x08) m_cbVPswT1.SetCurSel(1); else m_cbVPswT1.SetCurSel(0);
	if (buff[0] & 0x04) m_cbVPswT2.SetCurSel(1); else m_cbVPswT2.SetCurSel(0);
	m_eVPwsT1.SetWindowText(CPanelSettings::ConvertOneValue(buff, 2, 10, 8, 10));//bytes2string(buff[10],buff[11]));//INTEGER READ
	m_eVPwsT2.SetWindowText(CPanelSettings::ConvertOneValue(buff, 2, 12, 8, 10));//bytes2string(buff[12],buff[13]));//INTEGER READ

	CString gwt = CPanelSettings::ConvertOneValue(buff, 2, 14, 3, 1);
	m_eGlobalWTime.SetWindowText(gwt);//bytes2string(buff[14],buff[15]));
	if (gwt == "00:00:00") m_cbDisable.SetCheck(1); else m_cbDisable.SetCheck(0);
	OnBnClickedCheckScriptDisable();

	if (buff[0] & 0x02) m_bScriptRepeat.SetCheck(1); else m_bScriptRepeat.SetCheck(0);
	if (buff[0] & 0x01) m_bScriptNext.SetCheck(1); else m_bScriptNext.SetCheck(0);
}

void CPanelScripts::OnBnClickedButtonScriptSend()
{
	if (!m_pMainDlg->m_pDcDcUsb)
	{
		AfxMessageBox("No device connected!");
		return;
	}

	unsigned char chPackages[SCRIPTS_PACKS*16];
	memcpy(chPackages, m_chPackages, SETTINGS_PACKS*16);

	int scriptno = m_cbScriptNo.GetCurSel() % 4;
	unsigned char* buff = chPackages + scriptno*16;

	//flags
	unsigned char flags = 0;
	if (m_cbVoutT1.GetCurSel()==1)	flags |= 0x80;
	if (m_cbVoutT2.GetCurSel()==1)	flags |= 0x40;
	if (m_cbVAuxT1.GetCurSel()==1)	flags |= 0x20;
	if (m_cbVAuxT2.GetCurSel()==1)	flags |= 0x10;
	if (m_cbVPswT1.GetCurSel()==1)	flags |= 0x08;
	if (m_cbVPswT2.GetCurSel()==1)	flags |= 0x04;
	if (m_bScriptNext.GetCheck())	flags |= 0x01;
	if (m_bScriptRepeat.GetCheck()) flags |= 0x02;
	buff[0] = flags;
	
	unsigned char c1,c2;
	//voltage
	CString str;
	m_eVoltage.GetWindowText(str);
	if (!CPanelSettings::ReadOneValue(str,7,0,1,c1,c2))
	{
		AfxMessageBox("Wrong voltage!");
		return;
	}
	buff[1] = c2;
	
	//timers
	m_eVOutT1.GetWindowText(str);
	if (CPanelSettings::ReadOneValue(str, 3, 1, 2, c1, c2))
	{
		buff[2] = c1;
		buff[3] = c2;
	}
	else
	{
		AfxMessageBox("Wrong timer: VOutT1!");
		return;
	}

	m_eVOutT2.GetWindowText(str);
	if (CPanelSettings::ReadOneValue(str, 3, 1, 2, c1, c2))
	{
		buff[4] = c1;
		buff[5] = c2;
	}
	else
	{
		AfxMessageBox("Wrong timer: VOutT2!");
		return;
	}

	m_eVAuxT1.GetWindowText(str);
	if (CPanelSettings::ReadOneValue(str, 3, 1, 2, c1, c2))
	{
		buff[6] = c1;
		buff[7] = c2;
	}
	else
	{
		AfxMessageBox("Wrong timer: VAuxT1!");
		return;
	}

	m_eVAuxT2.GetWindowText(str);
	if (CPanelSettings::ReadOneValue(str, 3, 1, 2, c1, c2))
	{
		buff[8] = c1;
		buff[9] = c2;
	}
	else
	{
		AfxMessageBox("Wrong timer: VAuxT2!");
		return;
	}

	m_eVPwsT1.GetWindowText(str);
	if (CPanelSettings::ReadOneValue(str, 8, 10, 2, c1, c2))
	{
		buff[10] = c1;
		buff[11] = c2;
	}
	else
	{
		AfxMessageBox("Wrong timer: VPwsT1!");
		return;
	}

	m_eVPwsT2.GetWindowText(str);
	if (CPanelSettings::ReadOneValue(str, 8, 10, 2, c1, c2))
	{
		buff[12] = c1;
		buff[13] = c2;
	}
	else
	{
		AfxMessageBox("Wrong timer: VPwsT2!");
		return;
	}
	
	if (m_cbDisable.GetCheck())
	{
		m_eGlobalWTime.SetWindowText("00:00:00");
		buff[14] = 0;
		buff[15] = 0;
	}
	else
	{
		m_eGlobalWTime.GetWindowText(str);
		if (CPanelSettings::ReadOneValue(str, 3, 1, 2, c1, c2))
		{
			if ((c1 == 0) && (c2 == 0))
			{
				AfxMessageBox("Global Wait Time cannot be 0!");
				return;
			}
			else
			{
				buff[14] = c1;
				buff[15] = c2;
			}
		}
		else
		{
			AfxMessageBox("Wrong timer: Global Wait Time!");
			return;
		}
	}


	bool ok = true;
	if (m_pMainDlg->m_pDcDcUsb)
	{
		////////// SEND ///////////
		//erase

		unsigned long addr = m_nLastSelectedAddress;

		if (m_pMainDlg->m_pDcDcUsb)
		{
			if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_ERASE, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x40)) ok = false;
		}else ok = false;

		//write
		if (m_pMainDlg->m_pDcDcUsb)
		{
			if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages		, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
		}else ok = false;

		addr += 16;
		if (m_pMainDlg->m_pDcDcUsb)
		{
			if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+16	, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
		}else ok = false;

		addr += 16;
		if (m_pMainDlg->m_pDcDcUsb)
		{
			if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+2*16	, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
		}else ok = false;

		addr += 16;
		if (m_pMainDlg->m_pDcDcUsb)
		{
			if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+3*16	, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
		}else ok = false;
	}
	else ok = false;

	if (!ok)
		AfxMessageBox("Error occured during write - please retry!");
}

void CPanelScripts::OnBnClickedButtonScriptSleep()
{
	CSleepDialog dlg(this);
	dlg.DoModal();
}

void CPanelScripts::OnBnClickedCheckScriptDisable()
{
	if (m_cbDisable.GetCheck())
	{
		m_eVoltage.EnableWindow(FALSE);
		m_cbVoutT1.EnableWindow(FALSE);
		m_cbVoutT2.EnableWindow(FALSE);
		m_cbVAuxT1.EnableWindow(FALSE);
		m_cbVAuxT2.EnableWindow(FALSE);
		m_cbVPswT1.EnableWindow(FALSE);
		m_cbVPswT2.EnableWindow(FALSE);
		m_eVOutT1.EnableWindow(FALSE);
		m_eVOutT2.EnableWindow(FALSE);
		m_eVAuxT1.EnableWindow(FALSE);
		m_eVAuxT2.EnableWindow(FALSE);
		m_eVPwsT1.EnableWindow(FALSE);
		m_eVPwsT2.EnableWindow(FALSE);
		m_eGlobalWTime.EnableWindow(FALSE);
		m_bScriptNext.EnableWindow(FALSE);
		m_bScriptRepeat.EnableWindow(FALSE);
	}
	else
	{
		m_eVoltage.EnableWindow(TRUE);
		m_cbVoutT1.EnableWindow(TRUE);
		m_cbVoutT2.EnableWindow(TRUE);
		m_cbVAuxT1.EnableWindow(TRUE);
		m_cbVAuxT2.EnableWindow(TRUE);
		m_cbVPswT1.EnableWindow(TRUE);
		m_cbVPswT2.EnableWindow(TRUE);
		m_eVOutT1.EnableWindow(TRUE);
		m_eVOutT2.EnableWindow(TRUE);
		m_eVAuxT1.EnableWindow(TRUE);
		m_eVAuxT2.EnableWindow(TRUE);
		m_eVPwsT1.EnableWindow(TRUE);
		m_eVPwsT2.EnableWindow(TRUE);
		m_eGlobalWTime.EnableWindow(TRUE);
		m_bScriptNext.EnableWindow(TRUE);
		m_bScriptRepeat.EnableWindow(TRUE);
	}
}

int CPanelScripts::getLoadStatus()
{
	int cnt = 0;
	for (int i=0;i<SCRIPTS_PACKS;i++)
		if (m_bPackagesArrived[i]) cnt++;

	return cnt;
}
